/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.util;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class ReversedListIterator<E>
implements ListIterator<E> {
    private final ListIterator<E> li;
    private final int n;

    public ReversedListIterator(List<E> list) {
        this.li = list.listIterator(list.size());
        this.n = list.size();
        if (this.n == Integer.MAX_VALUE) {
            throw new IllegalArgumentException("List is too large.");
        }
    }

    public ReversedListIterator(List<E> list, int index) {
        this.li = list.listIterator(index);
        this.n = list.size();
        if (this.n == Integer.MAX_VALUE) {
            throw new IllegalArgumentException("List is too large.");
        }
    }

    @Override
    public void add(E o) {
        this.li.add(o);
    }

    @Override
    public boolean hasNext() {
        return this.li.hasPrevious();
    }

    @Override
    public boolean hasPrevious() {
        return this.li.hasNext();
    }

    @Override
    public E next() {
        return this.li.previous();
    }

    @Override
    public int nextIndex() {
        return this.n - this.li.previousIndex() - 1;
    }

    @Override
    public E previous() {
        return this.li.next();
    }

    @Override
    public int previousIndex() {
        return this.n - this.li.nextIndex() - 1;
    }

    @Override
    public void remove() {
        this.li.remove();
    }

    @Override
    public void set(E o) {
        this.li.set(o);
    }

    public static <T> Iterable<T> reversed(final List<T> list) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new ReversedListIterator(list);
            }
        };
    }
}

